{...}: let
  sshfs-users = {
    "spoody" = {
      authorizedKeys = [
        "ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIIFhTExbc9m4dCK6676wGiA8zPjE0l/9Fz2yf0IKvUvg spoody@archlinux"
        "ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIBtEJ4aQ4nn21ASBlVI54reYnWTefBBI1eUEkL0/adOe work@laptop"
        "ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAICPQ3uc8UB9m6NPkXHETTJrzxB6M+SfUiBx6YeWUSADU sxsgamer@gmail.com"
      ];
    };
  };
in {
  users.users =
    builtins.mapAttrs (name: value: {
      isNormalUser = true;
      openssh.authorizedKeys.keys = value.authorizedKeys;
    })
    sshfs-users;
  services.openssh.allowSFTP = true;
}
