{main-user ? throw "No main user"}: {
  pkgs,
  inputs,
  ...
}: {
  users.users.${main-user} = {
    isNormalUser = true;
    hashedPassword = import ../password.nix;
    extraGroups = [
      "networkmanager"
      "audio"
      "wheel"
      "jellyfin"
    ];
    openssh.authorizedKeys.keys = [
      "ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIIFhTExbc9m4dCK6676wGiA8zPjE0l/9Fz2yf0IKvUvg spoody@archlinux"
      "ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIBtEJ4aQ4nn21ASBlVI54reYnWTefBBI1eUEkL0/adOe work@laptop"
      "ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAICPQ3uc8UB9m6NPkXHETTJrzxB6M+SfUiBx6YeWUSADU sxsgamer@gmail.com"
      "ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIMh6OrSQ1k0M//j40rxoVFLMGsoZTtF3Fb+VO912WqTs u0_a327@localhost"
    ];

    shell = pkgs.fish;
  };

  programs.fish = {
    enable = true;
    shellAbbrs = {
      "nrb" = "nixos-rebuild --use-remote-sudo switch --flake /etc/nixos";
      "vmr" = "rm ~/.ssh/known_hosts; ssh root@10.0.0.1";
      "gc" = "sudo ${pkgs.writeShellScript "gc.sh" ''
        set -e
        nix store gc
        nix store optimise -v
      ''}";
    };
    shellAliases = {
      "fucking" = "sudo";
    };
  };

  # fish turns this on by default
  documentation.man.generateCaches = false;
}
