{
  lib,
  config,
  ...
}: {
  services.anubis = {
    defaultOptions = {
      enable = true;
      settings = {
        SERVE_ROBOTS_TXT = true;
        DIFFICULTY = 4;
        METRICS_BIND_NETWORK = "tcp";
        BIND_NETWORK = "tcp";
      };
    };
  };

  services.prometheus.scrapeConfigs = lib.mkIf config.services.prometheus.enable (
    lib.attrsets.mapAttrsToList (name: value: {
      job_name = name;
      static_configs = [
        {
          targets = ["localhost:${builtins.elemAt (builtins.split ":" (toString value.settings.METRICS_BIND)) 2}"];
        }
      ];
    })
    config.services.anubis.instances
  );
}
