{...}: let
  host = "127.0.0.1";
  domain = "spoodythe.one";
  port = 6167;
  mb = 1024 * 1024;
  max-request-size = 100;
in {
  services.matrix-conduit = {
    enable = true;
    settings.global = {
      address = host;
      server_name = domain;
      database_backend = "rocksdb";
      inherit port;
      enable_lightning_bolt = false;
      max_request_size = max-request-size * mb;
      allow_check_for_updates = false;
      allow_registration = false;
    };
  };

  services.nginx.virtualHosts."matrix.${domain}" = {
    addSSL = true;
    enableACME = true;
    locations."~ /_matrix/*" = {
      extraConfig = ''
        proxy_set_header Host $host;
        proxy_set_header X-Real-Ip $remote_addr;
        client_max_body_size ${toString max-request-size}M;
        proxy_pass http://${host}:${toString port};
      '';
    };
    # .proxyPass = "http://${host}:${toString port}";
  };
  services.nginx.virtualHosts."${domain}".locations = {
    "~ /.well-known/matrix/server" = {
      extraConfig = ''
        add_header Content-Type "application/json";
        add_header Access-Control-Allow-Origin *;
        return 200 '{"m.server" = "matrix.${domain}:443"}';
      '';
    };

    "~ /.well-known/matrix/client" = {
      extraConfig = ''
        add_header Content-Type "application/json";
        add_header Access-Control-Allow-Origin *;
        return 200 '${builtins.toJSON {
          "m.homeserver".base_url = "https://matrix.${domain}";
          "m.identity_server".base_url = "https://matrix.org";
          "org.matrix.msc3575.proxy".url = "https://matrix.${domain}";
        }}';
      '';
    };
  };
}
