{
  pkgs,
  config,
  ...
}: let
  freshrss-url = "rss.spoodythe.one";
  freshrss-port = 50000; # Make accessible on local network on port 50000

  rss-bridge-url = "rss-bridge.spoodythe.one";
  rss-bridge-port = 50001;
in {
  imports = [./nginx.nix];
  age.secrets.freshrss-password.owner = config.services.freshrss.user;
  services.freshrss = {
    enable = true;
    baseUrl = "https://${freshrss-url}";
    passwordFile = config.age.secrets.freshrss-password.path;
    extensions = with pkgs.freshrss-extensions; [
      youtube
      reading-time
      title-wrap
    ];
    virtualHost = freshrss-url;
  };

  services.nginx.virtualHosts.${freshrss-url} = {
    addSSL = true;
    enableACME = true;
    locations."/" = {
      extraConfig = ''
        client_max_body_size 100M;
      '';
    };
  };

  services.nginx.virtualHosts.${rss-bridge-url} = {
    # doesnt need to be front facing.
    listen = [
      {
        port = rss-bridge-port;
        addr = "0.0.0.0";
        ssl = false;
      }
    ];
  };

  services.rss-bridge = {
    enable = true;
    virtualHost = rss-bridge-url;
    config = {
      system.enabled_bridges = ["*"];
      error = {
        output = "http";
        report_limit = 5;
      };
      FileCache = {
        enable_purge = true;
      };
    };
  };
}
