{
  config,
  pkgs,
  ...
}: {
  imports = [
    ./docker.nix
    ../modules/age.nix
  ];
  services.gitea-actions-runner = {
    package = pkgs.forgejo-runner;
    instances = {
      agurk = {
        enable = true;
        name = "agurk";
        url = "http://127.0.0.1:${toString config.services.forgejo.settings.server.HTTP_PORT}";
        tokenFile = config.age.secrets.forgejo-runner-token.path;
        labels = [
          "native:host"
        ];
        hostPackages = pkgs.lib.attrValues {
          inherit
            (pkgs)
            nix
            nodejs
            git
            bash
            ripgrep
            openssh
            ;
        };
        settings = {
          log.level = "info";
          runner = {
            file = ".runner";
            capacity = 2;
            timeout = "3h";
            insecure = false;
            fetch_timeout = "5s";
            fetch_interval = "2s";
          };
        };
      };
      hval = pkgs.lib.mkIf false {
        enable = true;
        name = "hval";
        url = "http://172.17.0.1:${toString config.services.forgejo.settings.server.HTTP_PORT}";
        tokenFile = config.age.secrets.forgejo-runner-token.path;
        labels = [
          "docker:docker://node:16-bullseye"
        ];
        hostPackages = pkgs.lib.attrValues {
          inherit
            (pkgs)
            nix
            nodejs
            git
            bash
            fd
            ripgrep
            openssh
            ;
        };
        settings = {
          log.level = "info";
          runner = {
            file = ".runner";
            capacity = 2;
            timeout = "3h";
            insecure = false;
            fetch_timeout = "5s";
            fetch_interval = "2s";
          };
        };
      };
    };
  };

  system.activationScripts."make-gitea-runner-dir" = pkgs.lib.stringAfter ["var"] ''
    mkdir -p /var/lib/gitea-runner/
    # chown -R microvm:jellyfin /var/lib/gitea-runner
  '';

  # systemd.services = builtins.listToAttrs (pkgs.lib.attrsets.mapAttrsToList (
  #   name: value: {
  #     name = "gitea-runner-${name}";
  #     value = {
  #       serviceConfig.ReadWritePaths = "/srv/web";
  #     };
  #   }
  # ) config.services.gitea-actions-runner.instances);
}
