{...}: let
  host = "127.0.0.1";
  port = 3000;
in {
  imports = [
    ./nginx.nix
    ./prometheus.nix
  ];
  services.grafana = {
    enable = true;
    settings = {
      server.http_port = port;
      server.http_addr = "0.0.0.0";
      server.domain = "grafana.spoodythe.one";
    };
  };

  services.nginx.virtualHosts."grafana.spoodythe.one" = {
    addSSL = true;
    enableACME = true;
    locations."/" = {
      proxyPass = "http://${host}:${toString port}";
    };
  };
  networking.firewall.allowedTCPPorts = [port];
  networking.firewall.allowedUDPPorts = [port];
}
