{config, ...}: let
  host = "127.0.0.1";
  port = 1803;
in {
  services.graphite = {
    web = {
      enable = true;
      inherit port;
      listenAddress = host;
    };
  };

  # Nginx
  services.nginx.virtualHosts."graphite.spoodythe.one" = {
    addSSL = true;
    enableACME = true;
    locations."/" = {
      proxyPass = "http://${host}:${toString port}";
    };
  };

  networking.firewall.allowedTCPPorts = [port];
  networking.firewall.allowedUDPPorts = [port];
}
