{
  lib,
  pkgs,
  config,
  ...
}: let
  host = "127.0.0.1";
  port = 8096;
  gid = 989;
in {
  imports = [./nginx.nix];
  # Enable VAAPI
  config.nixpkgs.config.packageOverrides = pkgs: {
    vaapiIntel = pkgs.vaapiIntel.override {enableHybridCodec = true;};
  };
  config.hardware.graphics = {
    enable = true;
    extraPackages = with pkgs; [
      intel-media-driver
      intel-vaapi-driver
      vaapiVdpau
      intel-compute-runtime # OpenCL filter support (hardware tonemapping and subtitle burn-in)
      vpl-gpu-rt # QSV on 11th gen or newer
    ];
  };

  # Set declarative gid
  config.users.groups.jellyfin.gid = gid;

  # Create folder for media
  config.system.activationScripts."jellyfinMediaFolder" = lib.stringAfter ["var"] ''
    mkdir -p /var/lib/media
    chown -R jellyfin:jellyfin /var/lib/media
  '';

  # Enable Jellyfin
  config.services.jellyfin = {
    enable = true;
    openFirewall = false; # We want jellyfin behind a reverse proxy
  };

  config.services.nginx.
    virtualHosts."plex.iouhase.net" = {
    forceSSL = true;
    enableACME = true;
    locations."/" = {
      proxyPass = "http://${host}:${toString port}";
      proxyWebsockets = true;
      extraConfig = ''
        # Websocket support
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection $http_connection;

        # Disable buffering when the nginx proxy gets very resource heavy upon streaming
        proxy_buffering off;
      '';
    };
  };
}
