{...}: let
  host = "127.0.0.1";
  port = 5056;
in {
  imports = [./jellyfin.nix];

  services.jellyseerr = {
    enable = true;
    openFirewall = true;
    inherit port;
  };

  services.nginx.virtualHosts."jellyseerr.spoodythe.one" = {
    addSSL = true;
    enableACME = true;
    locations."/" = {
      proxyPass = "http://${host}:${toString port}";
    };
  };
}
