{
  config,
  pkgs,
  ...
}: let
  nextcloud-pkg = pkgs.nextcloud30;
  host = "127.0.0.1";
  port = 8008;
  lib = pkgs.lib;
in {
  #  system.activationScripts."make-nextcloud-dir" = lib.stringAfter ["var"] ''
  #    mkdir -p /var/lib/nextcloud
  #    chmod -R 770 /var/lib/nextcloud
  #    chown -R nextcloud:nextcloud /var/lib/nextcloud
  #  '';

  services.nextcloud = {
    enable = true;
    package = nextcloud-pkg;
    hostName = "localhost";
    config.adminpassFile = "/etc/nextcloud-admin-password";
    config.dbtype = "sqlite";
    settings.port = port;
  };

  # Place nextcloud behind a reverse proxy
  services.nginx.virtualHosts."nextcloud.spoodythe.one" = {
    forceSSL = true;
    enableACME = true;
    locations."/" = {
      proxyPass = "http://${host}:${toString port}";
    };
  };

  # Open port 80 and 443 for reverse proxy
  networking.firewall.allowedTCPPorts = [80 443];
  networking.firewall.allowedUDPPorts = [80 443];
}
