{
  pkgs,
  config,
  ...
}: {
  services.nginx = {
    enable = true;
    recommendedGzipSettings = true;
    recommendedOptimisation = true;
    recommendedProxySettings = true;
    recommendedTlsSettings = true;
    statusPage = true;
    additionalModules = with pkgs.nginxModules; [
      vts
      geoip2
    ];
  };

  security.acme.acceptTerms = true;
  security.acme.defaults.email = "sxsgamer@gmail.com";

  # Open port 80 and 443 for reverse proxy
  networking.firewall.allowedTCPPorts = [80 443];
  networking.firewall.allowedUDPPorts = [80 443];

  services.nginx.appendHttpConfig = "vhost_traffic_status_zone;";

  services.nginx.virtualHosts."localhost" = {
    locations."/metrics" = {
      extraConfig = ''
        vhost_traffic_status_display;
        vhost_traffic_status_display_format prometheus;
        allow 127.0.0.1;
        allow ::1;
        deny all;
      '';
    };
  };

  services.prometheus.exporters.nginx = {
    enable = true;
    port = 32002;
  };
  services.prometheus.scrapeConfigs = [
    {
      job_name = "nginx";
      static_configs = [
        {
          targets = [
            "localhost:${toString config.services.prometheus.exporters.nginx.port}"
            "localhost" # nginx vts
          ];
        }
      ];
    }
  ];
}
