{pkgs, ...}: let
  port = 60000;
in {
  imports = [./nginx.nix];

  services.nginx.virtualHosts."the-wheel.spoodythe.one" = {
    addSSL = true;
    enableACME = true;
    locations."/" = let
      package = pkgs.stdenv.mkDerivation {
        name = "the-wheel-website";
        version = "0.1";

        src = fetchGit {
          url = "https://git.spoodythe.one/spoody/the-wheel.git";
          ref = "master";
          rev = "d777bc65285db7120ad20e2d34927bc38c1ca220";
        };

        installPhase = ''
          mkdir -p $out
          cp -r $src/* $out
        '';
      };
    in {
      root = "${package}";
    };
  };
  networking.firewall.allowedTCPPorts = [port];
  networking.firewall.allowedUDPPorts = [port];
}
