{pkgs, ...} @ inputs: let
  port = 6167;
  host = "127.0.0.1";
  domain = "spoodythe.one";
  mb = 1024 * 1024;
  max-request-size = 20;
in {
  imports = [
    ../nginx.nix
  ];

  # services.matrix-conduit = {
  #   enable = true;
  #   package = pkgs.callPackage (import ./package.nix) {};
  #   settings = {
  #     global = {
  #       port = port;
  #       address = host;
  #       server_name = domain;
  #       max_request_size = max-request-size * mb;
  #
  #       allow_check_for_updates = false;
  #       allow_registration = false;
  #       enable_lightning_bolt = false;
  #       database_backend = "rocksdb";
  #     };
  #   };
  # };

  services.nginx.virtualHosts."matrix.${domain}" = {
    addSSL = true;
    enableACME = true;
    locations."/_matrix" = {
      proxyPass = "http://${host}:${toString port}";
      extraConfig = ''
        client_max_body_size ${toString max-request-size}M;
      '';
    };
  };
  services.nginx.virtualHosts."${domain}".locations = {
    "/.well-known/matrix/server".return = builtins.toJSON {
      "m.server" = "matrix.${domain}:443";
    };

    "/.well-known/matrix/client".return = builtins.toJSON {
      "m.homeserver".base_url = "https://matrix.${domain}";
      "m.identity_server".base_url = "https://matrix.org";
      "org.matrix.msc3575.proxy".url = "https://matrix.${domain}";
    };
  };

  # Open port so i can access it on my local network
  networking.firewall.allowedTCPPorts = [port 8448];
  networking.firewall.allowedUDPPorts = [port 8448];
}
