{config, ...}: let
  host = "127.0.0.1";
  port = 8222;
in {
  imports = [./nginx.nix];
  services.vaultwarden = {
    enable = true;

    environmentFile = "/var/lib/vaultwarden/environment.env";

    config = {
      DOMAIN = "https://vaultwarden.spoodythe.one";
      SIGNUPS_ALLOWED = false;

      ROCKET_ADDRESS = host;
      ROCKET_PORT = port;
      ROCKET_LOG = "critical";

      SMTP_HOST = host;
      SMTP_PORT = 25;
      SMTP_SSL = false;

      SMTP_FROM = "vaultwarden@spoodythe.one";
      SMTP_FROM_NAME = "SpoodyThe.One Bitwarden Server";
    };
  };

  services.nginx.virtualHosts."vaultwarden.spoodythe.one" = {
    enableACME = true;
    forceSSL = true;
    locations."/" = {
      proxyPass = "http://${host}:${toString port}";

      extraConfig = ''
        # Websocket support
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection $http_connection;
      '';
    };
  };
}
