{
  fetchFromGitLab,
  pkgs,
  ...
}: let
  host = "127.0.0.1";
  port = 8080;
  user = "website-host-user";
  repo = "https://git.spoodythe.one/spoody/website";
in {
  imports = [./nginx.nix];
  services.nginx.virtualHosts."spoodythe.one" = {
    enableACME = true;
    forceSSL = true;
    default = true;
    # locations."/" = {
    #   proxyPass = "http://${host}:${toString port}";
    # };
  };

  users.users."${user}" = {
    isSystemUser = true;
    home = "/home/${user}";
    createHome = true;
    group = "${user}";
    shell = pkgs.bash;
    openssh.authorizedKeys.keys = [
      "ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIG90JNokb4/4DZ/2tHS8Lj/jq+UiA0B2g+MFeM8KuA6Y website-host-user@server"
    ];
  };
  users.groups."${user}" = {};

  security.sudo.extraRules = [
    {
      users = ["${user}"];
      commands = [
        {
          command = "/run/current-system/sw/bin/systemctl restart rebuild-website.service";
          options = ["SETENV" "NOPASSWD"];
        }
        {
          command = "/run/current-system/sw/bin/systemctl start rebuild-website.service";
          options = ["SETENV" "NOPASSWD"];
        }
        {
          command = "/run/current-system/sw/bin/systemctl restart website.service";
          options = ["SETENV" "NOPASSWD"];
        }
      ];
    }
  ];

  systemd.services = {
    "rebuild-website" = {
      description = "Service for rebuilding website";
      wants = ["network-online.target" "forgejo.service"];
      after = ["network-online.target" "forgejo.service"];

      script = ''
        path="/home/${user}/website"
        if [ ! -d "$path" ]; then
          echo "Cloning repo"
          ${pkgs.git}/bin/git clone ${repo} "$path"
        fi
        echo "cd $path"
        cd "$path"
        echo "[git] Pulling changes..."
        ${pkgs.git}/bin/git pull
        echo "[nix build] Rebuilding website flake..."
        ${pkgs.nix}/bin/nix build                                                         # build
        echo "[systemctl] Restarting website service"
        /run/wrappers/bin/sudo /run/current-system/sw/bin/systemctl restart website.service       # run new website
      '';

      serviceConfig = {
        Type = "oneshot";
        RemainsAfterExit = false;
        User = user;
      };
    };

    "website" = {
      description = "Runs my website";
      wants = ["network-online.target"];
      after = ["network-online.target"];
      wantedBy = ["multi-user.target"];

      preStart = ''
        path="/home/${user}/website/result/bin"
        if [ ! -d "$path" ]; then
          /run/wrappers/bin/sudo /run/current-system/sw/bin/systemctl start rebuild-website.service       # rebuild website if it doesnt exist
        fi
      '';

      script = ''
        path="/home/${user}/website/result/bin"
        cd "$path"
        ./webbisitey-wrapped
      '';

      serviceConfig = {
        Type = "exec";
        Restart = "always";
        User = user;
      };
    };
  };
}
